/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.settings.user;

import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.settings.user.UserSettingsErrorIds;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class ObjectLockingSettings
implements UserSettingsErrorIds {
    private boolean lock;
    private boolean relock;
    private static transient ObjectLockingSettings instance;
    private static final FrameworkClassLogInfo classLogInfo;
    private static final String CLASS_NAME = "com.ibm.hwmca.fw.settings.user.ObjectLockingSettings";
    private static final String TRACE_MASKT = "HUIUSOLT";
    private static final String TRACE_MASKF = "HUIUSOLF";
    private static final String TRACE_MASKD = "HUIUSOLD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$settings$user$ObjectLockingSettings$SaveRestore;

    private ObjectLockingSettings(Properties properties) {
        Trace.trace(TRACE_MASKT, "<> ObjectLockingSettings(Properties)");
        this.lock = Boolean.valueOf((String)properties.get("lock.objects"));
        this.relock = Boolean.valueOf((String)properties.get("lock.relock"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ObjectLockingSettings getObjectLockingSettings() {
        if (instance == null) {
            Trace.trace(TRACE_MASKF, " instance is null, instantiate the singleton.");
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                String fileName = BaseFileControl.getFilePath("defaultuserpref.properties");
                File inFile = new File(fileName + File.separator + "defaultuserpref.properties");
                fis = new FileInputStream(inFile);
                fileName = BaseFileControl.getFilePath("defaultuserpref.original.properties");
                File outFile = new File(fileName + File.separator + "defaultuserpref.original.properties");
                if (!outFile.exists()) {
                    Properties original = new Properties();
                    original.load(fis);
                    fos = new FileOutputStream(outFile);
                    original.store(fos, null);
                    instance = new ObjectLockingSettings(original);
                } else {
                    Properties props = new Properties();
                    props.load(fis);
                    instance = new ObjectLockingSettings(props);
                }
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, " caught exception " + exc);
                new FrameworkLog(classLogInfo, 1984, exc).log();
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException exc) {}
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ObjectLockingSettings getDefault() {
        ObjectLockingSettings result;
        block11: {
            result = null;
            FileInputStream fis = null;
            String fileName = BaseFileControl.getFilePath("defaultuserpref.original.properties");
            File file = new File(fileName + File.separator + "defaultuserpref.original.properties");
            Properties properties = new Properties();
            fis = new FileInputStream(file);
            properties.load(fis);
            result = new ObjectLockingSettings(properties);
            Object var6_6 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                break block11;
            }
            catch (IOException exc2) {}
            break block11;
            {
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, " caught exception " + exc);
                    new FrameworkLog(classLogInfo, 1985, exc).log();
                    Object var6_7 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block11;
                    }
                    catch (IOException exc2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException exc2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    public static void lockAll() {
        Trace.trace(TRACE_MASKT, "-> ObjectLockingSettings.lockAll()");
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        Set objectIds = mom.getInventoryObjectIds(new ClassId("com.ibm.hwmca.fw.managed", "ManagedObject"));
        Iterator iterator = objectIds.iterator();
        while (iterator.hasNext()) {
            try {
                mom.setProperty((ObjectId)iterator.next(), "Locked", Boolean.TRUE);
            }
            catch (UnsupportedOperationException exc) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKT, "<- ObjectLockingSettings.lockAll()");
    }

    public boolean getLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        if (this.lock != lock) {
            this.lock = lock;
            this.persist();
        }
    }

    public boolean getRelock() {
        return this.relock;
    }

    public void setRelock(boolean relock) {
        if (this.relock != relock) {
            this.relock = relock;
            this.persist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            String fileName = BaseFileControl.getFilePath("defaultuserpref.properties");
            File file = new File(fileName + File.separator + "defaultuserpref.properties");
            fis = new FileInputStream(file);
            Properties props = new Properties();
            props.load(fis);
            fis.close();
            fis = null;
            if (this.getLock()) {
                props.setProperty("lock.objects", "true");
            } else {
                props.setProperty("lock.objects", "false");
            }
            if (this.getRelock()) {
                props.setProperty("lock.relock", "true");
            } else {
                props.setProperty("lock.relock", "false");
            }
            fos = new FileOutputStream(file);
            props.store(fos, null);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, " caught exception " + exc);
            new FrameworkLog(classLogInfo, 1988, exc).log();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException exc) {}
        }
    }

    private void persist() {
        try {
            PersistenceManager pm = PersistenceManager.getPersistenceManager();
            pm.write(CLASS_NAME, new Persistent(this));
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, " Error, caught exception " + exc);
            new FrameworkLog(classLogInfo, 1986, exc).log();
        }
    }

    public String toString() {
        return super.toString() + ",lock=" + this.getLock() + ",relock=" + this.getRelock();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        classLogInfo = new FrameworkClassLogInfo(85, "ObjectLocking");
    }

    private static class Persistent
    implements PersistentData {
        int version = 0;
        boolean lock;
        boolean relock;
        private static final long serialVersionUID = 3063651023266936826L;

        Persistent(ObjectLockingSettings settings) {
            this.lock = settings.getLock();
            this.relock = settings.getRelock();
        }
    }

    public static class SaveRestore
    implements CustomizableData {
        public SaveRestore() {
            Trace.trace(ObjectLockingSettings.TRACE_MASKT, "<> ObjectLockingSettings.SaveRestore");
        }

        public UIInfo getUIInfo() {
            Trace.trace(ObjectLockingSettings.TRACE_MASKT, "<> ObjectLockingSettings.getUIInfo()");
            return new UIInfo(new LocalizableText(BaseTextBundle.getBundleName(), "objectlocking.name"), new LocalizableText(BaseTextBundle.getBundleName(), "objectlocking.caption"));
        }

        public Serializable getSaveableData() {
            ObjectLockingSettings settings = ObjectLockingSettings.getObjectLockingSettings();
            Trace.trace(ObjectLockingSettings.TRACE_MASKT, "<> ObjectLockingSettings.getSaveableData()");
            return new Persistent(settings);
        }

        public void restoreData(Serializable obj) {
            Trace.trace(ObjectLockingSettings.TRACE_MASKT, "<> ObjectLockingSettings.restoreData()");
            ObjectLockingSettings settings = ObjectLockingSettings.getObjectLockingSettings();
            settings.setLock(((Persistent)obj).lock);
            settings.setRelock(((Persistent)obj).relock);
            settings.store();
            if (settings.getLock()) {
                settings.lockAll();
            }
        }

        public String getCustomDataKey() {
            return (class$com$ibm$hwmca$fw$settings$user$ObjectLockingSettings$SaveRestore == null ? (class$com$ibm$hwmca$fw$settings$user$ObjectLockingSettings$SaveRestore = ObjectLockingSettings.class$("com.ibm.hwmca.fw.settings.user.ObjectLockingSettings$SaveRestore")) : class$com$ibm$hwmca$fw$settings$user$ObjectLockingSettings$SaveRestore).getName();
        }
    }
}

